#    pyLamma is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    pyLamma is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <https://www.gnu.org/licenses/>.

#   company/organization: MR_ROBOT_COMPUTERS_REPAIR
#   Country: Italy
#   City: Barga (LU)
#   website: mrrobotcomputers.hopto.org
#   mail address: mrrobotcomputersrepair@gmail.com



import xml.dom
from xml.dom import minidom
import urllib.request

class pyLamma:

	url="http://www.lamma.rete.toscana.it/previ/ita/xml/comuni_web/dati/"
	_version="pyLamma v0.1"

	DAY="giorno"
	MORNING="mattina"
	AFTERNOON="pomeriggio"
	EVENING="sera"
	NIGHT="notte"

	TEMP_MIN="min"
	TEMP_MAX="max"
	TEMP_REAL=""
	TEMP_PERC="perc"

	HYDRO_RISK="idraulico"
	GEO_HYDRO_RISK="idrogeologico"
	THUNDERSTORM_RISK="temporali"
	WIND_RISK="vento"
	SNOW_RISK="neve"
	ICE_RISK="ghiaccio"

	city_list=[]
	your_city=""
	previsions=[]

	def _dataURL(self): #ok
		return self.url

	def getCityList(self): #ok
		cityListUrl="http://www.lamma.rete.toscana.it/previ/ita/xml/lista_comuni.xml"
		xml_str=urllib.request.urlopen(cityListUrl).read()
		xml_doc=minidom.parseString(xml_str)

		city_list_xml=xml_doc.getElementsByTagName("title")
		for city in city_list_xml:
			self.city_list.append(city.firstChild.nodeValue)

		return self.city_list

	def selectCity(self,city): #ok
		try:
			cityURL="http://www.lamma.rete.toscana.it/previ/ita/xml/comuni_web/dati/"+city.replace(" ","").lower()+".xml"
			xml_str=urllib.request.urlopen(cityURL).read()
			xml_doc=minidom.parseString(xml_str)
			self.your_city=xml_doc
			return self.your_city
		except:
			return False

	def name(self,city): #ok
			try:
				name=city.getElementsByTagName("comune")
				return name[0].firstChild.nodeValue
			except:
				return False

	def getUnixTimestamp(self,city): #ok
		try:
			timestamp=city.getElementsByTagName("time_ms")
			return timestamp[0].firstChild.nodeValue
		except:
			return None

	def lastUpdate(self,city): #ok

			try:
				name=city.getElementsByTagName("aggiornamento")
				return name[0].firstChild.nodeValue
			except:
				return None

	def sunrise(self,city): #ok


			try:
				name=city.getElementsByTagName("sole_sorge")
				return name[0].firstChild.nodeValue
			except:
				return None

	def sunset(self,city): #ok

			try:
				name=city.getElementsByTagName("sole_tramonta")
				return name[0].firstChild.nodeValue
			except:
				return None

	def sun_height(self,city): #ok

			try:
				name=city.getElementsByTagName("sole_altezza")
				return name[0].firstChild.nodeValue
			except:
				return None

	def max_sun_hour(self,city): #ok

			try:
				name=city.getElementsByTagName("ora_altezza")
				return name[0].firstChild.nodeValue
			except:
				return None

	def moon_rises(self,city): #ok

			try:
				name=city.getElementsByTagName("luna_sorge")
				return name[0].firstChild.nodeValue
			except:
				return None

	def moon_sets(self,city): #ok

			try:
				name=city.getElementsByTagName("luna_tramonta")
				return name[0].firstChild.nodeValue
			except:
				return None

	def getPrevisions(self,city): #ok

			try:
				prev=city.getElementsByTagName("previsione")
				for previsione in prev:
					self.previsions.append(previsione)
				return self.previsions
			except:
				return False

	def getDayByIdday(self,idday,prevs): #ok
			try:
				for prev in prevs:
					if prev.getAttribute("idday") == str(idday):
						return prev.getAttribute("datadescr")
			except:
				return False

	def getWeather(self,idday,time,prevs): #ok
			try:
				for prev in prevs:
					if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == time:
						weather=prev.getElementsByTagName("simbolo")
						return weather[0].getAttribute("descr")
			except:
				return False

	def getWeatherStat_wind(self,idday,time,prevs): #ok
			try:
				for prev in prevs:
					if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == time:
						stat=prev.getElementsByTagName("simbolo")
						return stat[1].getAttribute("descr")
			except:
				return None

	def getWeatherStat_temps(self,idday,time,prevs): #ok
			try:
				for prev in prevs:
					if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == time:
						stat=prev.getElementsByTagName("simbolo")
						return stat[2].getAttribute("descr")
			except:
				return None

	def getUV(self,idday,time,prevs):
			try:
				for prev in prevs:
					if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == time:
						uv=prev.getElementsByTagName("uv")
						return uv[0].firstChild.nodeValue
			except:
				return None

	def getTemps(self,idday,time,temp_type,prevs): #ok

		if time == self.DAY and temp_type == self.TEMP_REAL:
			return 'WARNING: self.DAY'+" "+' + self.TEMP_REAL'+" is not valid data schema: "+' use self.TEMP_MIN or self.TEMP_MAX with self.DAY constant'

		if time == self.DAY and temp_type == self.TEMP_PERC:
			return 'WARNING: self.DAY'+" "+' + self.TEMP_REAL'+" is not valid data schema: "+' use self.TEMP_MIN or self.TEMP_MAX with self.DAY constant'

		if time == self.MORNING and temp_type == self.TEMP_MIN or time == self.MORNING and temp_type == self.TEMP_MAX: 
			return 'WARNING: self.MORNING'+" "+' + self.TEMP_MIN / self.TEMP_MAX'+" is not valid data schema: "+' use self.TEMP_PERC or self.TEMP_REAL with self.MORNING constant'

		if time == self.AFTERNOON and temp_type == self.TEMP_MIN or time == self.AFTERNOON and temp_type == self.TEMP_MAX: 
			return 'WARNING: self.AFTERNOON'+" "+' + self.TEMP_MIN / self.TEMP_MAX'+" is not valid data schema: "+' use self.TEMP_PERC or self.TEMP_REAL with self.AFTERNOON constant'

		if time == self.EVENING and temp_type == self.TEMP_MIN or time == self.EVENING and temp_type == self.TEMP_MAX: 
			return 'WARNING: self.EVENING'+" "+' + self.TEMP_MIN / self.TEMP_MAX'+" is not valid data schema: "+' use self.TEMP_PERC or self.TEMP_REAL with self.EVENING constant'

		if time == self.NIGHT and temp_type == self.TEMP_MIN or time == self.NIGHT and temp_type == self.TEMP_MAX: 
			return 'WARNING: self.NIGHT'+" "+' + self.TEMP_MIN / self.TEMP_MAX'+" is not valid data schema: "+' use self.TEMP_PERC or self.TEMP_REAL with self.NIGHT constant'
		try:

			for prev in prevs:
				if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == time:
					temp=prev.getElementsByTagName("temp")

					if temp_type == self.TEMP_MIN:
						if temp[0].getAttribute("temp_type") == temp_type:
							temp=temp[0].firstChild.nodeValue
							return temp

					if temp_type == self.TEMP_MAX:
						if temp[1].getAttribute("temp_type") == temp_type:
							temp=temp[1].firstChild.nodeValue
							return temp

					if temp_type == self.TEMP_REAL:
						if temp[0].getAttribute("temp_type") == temp_type:
							temp=temp[0].firstChild.nodeValue
							return temp

					if temp_type == self.TEMP_PERC:
						if temp[1].getAttribute("temp_type") == temp_type:
							temp=temp[1].firstChild.nodeValue
							return temp
		except:
			return None

	def getInversion(self,idday,time,prevs):
	# Funziona tutto ma bisogna trovare un sistema per gestire meglio il valore di ritorno
	# in quanto è possibile che il valore assegnato al tag del file xml sia false
			try:
				for prev in prevs:
					if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == time:
						inversion=prev.getElementsByTagName("inversione")
						return inversion[0].firstChild.nodeValue
			except:
				return None

	def getHumidity(self,idday,time,prevs): #ok
			try:
				for prev in prevs:
					if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == time:
						um=prev.getElementsByTagName("um")
						return um[0].firstChild.nodeValue
			except:
				return None

	def getRainProbability(self,idday,time,prevs): #ok
			try:
				for prev in prevs:
					if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == time:
						rain_prob=prev.getElementsByTagName("prob_rain")
						return rain_prob[0].firstChild.nodeValue
			except:
				return None

	def getSnowLevel(self,idday,time,prevs): #ok
			try:
				for prev in prevs:
					if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == time:
						snow_lv=prev.getElementsByTagName("quota_neve")
						return snow_lv[0].firstChild.nodeValue
			except:
				return None

	def getAlert(self,idday,prevs): #ok
		try:
			for prev in prevs:
				if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == self.DAY:
					alert=prev.getElementsByTagName("allerta")
					return alert[0].getAttribute("value")
		except:
			return None


	def getRisk(self,idday,risk_type,prevs):
		try:
			for prev in prevs:
				if prev.getAttribute("idday") == str(idday) and prev.getAttribute("ora") == self.DAY:
					risk=prev.getElementsByTagName("rischio")

					if risk_type == "idraulico":
						return risk[0].getAttribute("value")

					elif risk_type == "idrogeologico":
						return risk[1].getAttribute("value")

					elif risk_type == "temporali":
						return risk[2].getAttribute("value")

					elif risk_type == "vento":
						return risk[3].getAttribute("value")

					elif risk_type == "neve":
						return risk[4].getAttribute("value")

					elif risk_type == "ghiaccio":
						return risk[5].getAttribute("value")
		except:
			return None


	def version(self):
		return self._version





